import pyfirmata2 as pyfirmata
from LiquidCrystal import lcd_print, lcd_init
import time

try:
    board = pyfirmata.Arduino(pyfirmata.Arduino.AUTODETECT)
except Exception as e:
    print("Could not connect to board:", e)


LCD_LINE_1 = 0x80
LCD_LINE_2 = 0xC0


def write(text):
    print("\033[A\033[A", end="")
    lcd_print(text.split("\n")[0], LCD_LINE_1)
    print("\033[44;33m" + text.split("\n")[0] + "\033[m")
    try:
        lcd_print(text.split("\n")[1], LCD_LINE_2)
        print("\033[44;33m" + text.split("\n")[1] + "\033[m")
    except:
        print("\033[44;33m                \033[m")


print("\n")
try:
    lcd_init(
        datapins=[
            False,
            False,
            False,
            False,
            board.get_pin('d:5:o'),
            board.get_pin('d:4:o'),
            board.get_pin('d:3:o'),
            board.get_pin('d:2:o')
        ],
        rs=board.get_pin('d:12:o'),
        e=board.get_pin('d:11:o'),
        LCD_WIDTH=16,
        LCD_CHR=True,
        LCD_CMD=False,
        E_PULSE=0.0005,
        E_DELAY=0.0005
    )

    while True:
        write(time.strftime('%a %d %b %Y ', time.localtime()) +
              '\n' + time.strftime('%H:%M:%S %Z', time.localtime())[:16])
except KeyboardInterrupt as e:
    print("KeyboardInterrupt")
