from pyfirmata2 import Arduino
try:
    from .httpserver import server
except:
    from httpserver import server

# connect to the board by autodetecting serial ports
board = Arduino(Arduino.AUTODETECT)


def req(data: str):
    """
    /<PIN>/<VALUE>/          set value
    /<PIN>/                  toggle
    """
    d = data.split("/")
    if d[1] == "favicon.ico":
        return
    print(d)
    try:
        if d[1] == "digital":
            board.digital[int(d[2])].write(int(d[3]))
        elif d[1] == "analog":
            board.analog[int(d[2])].write(int(d[3]))
    except:
        if d[1] == "digital":
            board.digital[int(d[2])].write(not board.digital[int(d[2])].read())
        elif d[1] == "analog":
            board.analog[int(d[2])].write(not board.analog[int(d[2])].read())


server("127.0.0.1", 1234, req)
