import time


def lcd_init(**kwargs):
    global datapins
    global rs
    global e
    global LCD_WIDTH
    global LCD_CHR
    global LCD_CMD
    global E_PULSE
    global E_DELAY

    datapins = kwargs.get('datapins')
    rs = kwargs.get('rs')
    e = kwargs.get('e')
    LCD_WIDTH = kwargs.get('LCD_WIDTH')
    LCD_CHR = kwargs.get('LCD_CHR')
    LCD_CMD = kwargs.get('LCD_CMD')
    E_PULSE = kwargs.get('E_PULSE')
    E_DELAY = kwargs.get('E_DELAY')

    rs.write(0)
    e.write(0)
    lcd_byte(0x33, LCD_CMD)
    lcd_byte(0x32, LCD_CMD)
    lcd_byte(0x06, LCD_CMD)
    lcd_byte(0x0C, LCD_CMD)
    lcd_byte(0x28, LCD_CMD)
    lcd_byte(0x01, LCD_CMD)
    time.sleep(E_DELAY)


def lcd_byte(bits, mode):
    rs.write(mode)
    datapins[4].write(0)
    datapins[5].write(0)
    datapins[6].write(0)
    datapins[7].write(0)
    if bits & 0x10 == 0x10:
        datapins[4].write(1)
    if bits & 0x20 == 0x20:
        datapins[5].write(1)
    if bits & 0x40 == 0x40:
        datapins[6].write(1)
    if bits & 0x80 == 0x80:
        datapins[7].write(1)
    lcd_toggle_enable()
    datapins[4].write(0)
    datapins[5].write(0)
    datapins[6].write(0)
    datapins[7].write(0)
    if bits & 0x01 == 0x01:
        datapins[4].write(1)
    if bits & 0x02 == 0x02:
        datapins[5].write(1)
    if bits & 0x04 == 0x04:
        datapins[6].write(1)
    if bits & 0x08 == 0x08:
        datapins[7].write(1)
    lcd_toggle_enable()


def lcd_toggle_enable():
    e.write(0)
    time.sleep(E_DELAY)
    e.write(1)
    time.sleep(E_PULSE)
    e.write(0)
    time.sleep(E_DELAY)


def lcd_print(message, line):
    message = message.ljust(LCD_WIDTH, " ")
    lcd_byte(line, LCD_CMD)
    for i in range(LCD_WIDTH):
        lcd_byte(ord(message[i]), LCD_CHR)
